package com.ejie.ab04b.webservice;

import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.ejie.ab04b.service.svt.SvtService;
import com.ejie.ab04b.service.util.ApplicationContextProvider;

/**
 * @author GFI-NORTE
 * 
 */
@WebService(serviceName = "svtWebService", portName = "svtWebServicePort", targetNamespace = "http://com.ejie.ab04b.webservice")
@SOAPBinding(parameterStyle = ParameterStyle.WRAPPED)
@HandlerChain(file = "server-handlers.xml")
public class SvtWebService extends SpringBeanAutowiringSupport {

	private static final Logger LOGGER = LoggerFactory
			.getLogger(SvtWebService.class);

	/**
	 * Devuelve el buzón del instructor del expediente.
	 * 
	 * folderId String procedureId String String
	 *
	 * @param folderId
	 *            the folder id
	 * @param procedureId
	 *            the procedure id
	 * @return the string
	 */
	@WebMethod()
	public String svtObtenerMailboxInstructor(String folderId,
			String procedureId) {

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		SvtService svtService = (SvtService) applicationContext
				.getBean("svtService");

		return svtService.obtenerMailboxInstructor(folderId, procedureId);
	}

	/**
	 * Devuelve el buzón de Osalan.
	 * 
	 * folderId String procedureId String String
	 *
	 * @param folderId
	 *            the folder id
	 * @param procedureId
	 *            the procedure id
	 * @return the string
	 */
	@WebMethod()
	public String svtObtenerMailboxOsalan(String folderId, String procedureId) {

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		SvtService svtService = (SvtService) applicationContext
				.getBean("svtService");

		return svtService.obtenerMailboxOsalan(folderId, procedureId);
	}

	/**
	 * Devuelve el buzón del instructor del expediente.
	 * 
	 * folderId String procedureID String String
	 *
	 * @param folderId
	 *            the folder id
	 * @param procedureID
	 *            the procedure ID
	 * @return the string
	 * @throws Exception
	 */
	@WebMethod()
	public String svtObtenerFolderNumber(String folderId, String procedureID) {

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		SvtService svtService = (SvtService) applicationContext
				.getBean("svtService");

		try {
			return svtService.obtenerFolderNumber(folderId, procedureID);
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Devuelve el buzón al que se debe mandar la tarea.
	 * 
	 * buzon String String
	 *
	 * @param buzon
	 *            the buzon
	 * @return the string
	 */
	@WebMethod()
	public String svtObtenerMailbox(String buzon) {

		SvtWebService.LOGGER.info("Entra en svtObtenerMailbox");

		return "AB04B-01";
	}

	/**
	 * Devuelve "S" si el expediente tiene marcado el check de Documentación
	 * Correcta. En caso contrario devuelve "N"
	 * 
	 * folderId String procedureId String String
	 *
	 * @param folderId
	 *            the folder id
	 * @param procedureId
	 *            the procedure id
	 * @return the string
	 */
	@WebMethod()
	public String svtExpedienteTieneDocCorrecta(String folderId,
			String procedureId) {

		SvtWebService.LOGGER.info("Entra en svtExpedienteTieneDocCorrecta");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		SvtService svtService = (SvtService) applicationContext
				.getBean("svtService");

		return svtService.expedienteTieneDocumentacionCorrecta(folderId,
				procedureId);
	}

	/**
	 * Método que realiza la tramitación en una tarea automática.
	 * 
	 * integrationToken the integration token taskID the task ID taskType String
	 * String
	 *
	 * @param integrationToken
	 *            the integration token
	 * @param taskID
	 *            the task ID
	 * @param taskType
	 *            the task type
	 * @return the string
	 */
	/*
	 * @WebMethod() public String svtProcessUrl(String token, String
	 * mailboxTaskId, String taskType) {
	 * 
	 * SvtWebService.LOGGER.info("Entra en svtProcessUrl");
	 * 
	 * ApplicationContext applicationContext = ApplicationContextProvider
	 * .getApplicationContext();
	 * 
	 * SvtService svtService = (SvtService) applicationContext
	 * .getBean("svtService");
	 * 
	 * try { svtService.process(mailboxTaskId, taskType); return
	 * Boolean.TRUE.toString(); } catch (Exception e) { SvtWebService.LOGGER
	 * .error("Se ha producido un error en svtProcessUrl", e); return
	 * Boolean.FALSE.toString(); } }
	 */

	/**
	 * Método que realiza la tramitación en una tarea automática
	 * 
	 * integrationToken String taskID String taskType String String
	 */
	@WebMethod()
	public String svtProcessUrl(
			@WebParam(name = "integrationToken") String integrationToken,
			@WebParam(name = "taskID") String taskID,
			@WebParam(name = "taskType") String taskType) {

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		SvtService svtService = (SvtService) applicationContext
				.getBean("svtService");

		try {
			svtService.process(taskID, taskType);
			return Boolean.TRUE.toString();
		} catch (Exception e) {
			SvtWebService.LOGGER
					.error("Se ha producido un error en svtProcessUrl", e);

			return Boolean.FALSE.toString();
		}
	}

	/**
	 * Devuelve 'S' o 'N' indicando si la comunicación de apertura es de Obra
	 * ('S') o de Centro ('N').
	 * 
	 * folderId String String
	 *
	 * @param folderId
	 *            the folder id
	 * @return the string
	 */
	@WebMethod()
	public String svtEsAperturaObra(String folderId) {

		SvtWebService.LOGGER.info("Entra en svtEsAperturaObra");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		SvtService svtService = (SvtService) applicationContext
				.getBean("svtService");

		return svtService.esAperturaObra(folderId);
	}

	/**
	 * Devuelve 'S' o 'N' indicando si la hay que realizar la comunicación OS2.
	 * 
	 * folderId String String
	 *
	 * @param folderId
	 *            the folder id
	 * @return the string
	 */
	@WebMethod()
	public String svtHayQueComunicarOS2(String folderId) {

		SvtWebService.LOGGER.info("Entra en svtHayQueComunicarOS2");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		SvtService svtService = (SvtService) applicationContext
				.getBean("svtService");

		return svtService.hayQueComunicarOS2(folderId);
	}

	/**
	 * Devuelve 'S' o 'N' indicando si la hay que realizar la comunicación OS3.
	 * 
	 * folderId String String
	 *
	 * @param folderId
	 *            the folder id
	 * @return the string
	 */
	@WebMethod()
	public String svtHayQueComunicarOS3(String folderId) {

		SvtWebService.LOGGER.info("Entra en svtHayQueComunicarOS3");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		SvtService svtService = (SvtService) applicationContext
				.getBean("svtService");

		return svtService.hayQueComunicarOS3(folderId);
	}

}